<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row mb-4">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <!-- <h1 class="mb-0 font-size-18">Gestión de Clubes</h1> -->
                    </div>
                </div>
            </div>
            <div class="row">
                <?php if (isset($_SESSION['success_message'])) : ?>
                    <script>
                        Swal.fire({
                            icon: "success",
                            title: "Éxito",
                            text: "<?php echo $_SESSION['success_message']; ?>",
                            timer: 1000,
                            showConfirmButton: true
                        });
                    </script>
                    <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                <?php if (isset($_SESSION['error_message'])) : ?>
                    <script>
                        toastr.error("<?php echo $_SESSION['error_message']; ?>" );
                    </script>
                    <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                <?php if (isset($_SESSION['success_messagea'])) : ?>
                    <script>
                        new Noty({
                            type: "success",
                            text: "<?php echo $_SESSION['success_messagea']; ?>",
                            timeout: 1000
                        }).show();
                    </script>
                    <?php unset($_SESSION['success_messagea']); ?>
                <?php endif; ?>
                <?php if (isset($_SESSION['success_messagea1'])) : ?>
                    <script>
                        new Noty({
                            type: "error",
                            text: "<?php echo $_SESSION['success_messagea1']; ?>",
                            timeout: 1000 
                        }).show();
                    </script>
                    <?php unset($_SESSION['success_messagea1']); ?>
                <?php endif; ?>
                <?php if (isset($_SESSION['eliminado'])) : ?>
                    <script>
                        Swal.fire({
                            icon: "error",
                            title: "Eliminado",
                            text: "<?php echo $_SESSION['eliminado']; ?>",
                            timer: 1000,
                            showConfirmButton: true
                        });
                    </script>
                    <?php unset($_SESSION['eliminado']); ?>
                <?php endif; ?>
                <div class="col">
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0 text-white text-center">Información del Inventario</h5>
                        </div>
                        <div class="card-body">
                            <table id="customerTable" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
                                <thead>
                                    <tr class="table-primary">
                                        <th>Articulo</th>
                                        <th>Categoria</th>
                                        <th>Código</th>
                                        <th>Marca</th>
                                        <th>Modelo</th>
                                        <th>Serie</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

<script>
$('#customerTable').DataTable({
    "responsive": true,
    "processing": true,
    "serverSide": true,
    "ajax": "index.php?action=apiinventario",
    "columns": [
        { "data": "nombre" },
        { "data": "categorias" },
        { "data": "codigo" },
        { "data": "marca" },
        { "data": "modelo" },
        { "data": "serie" },
    ],
    "dom": 'Bfrtip',
    buttons: [
        {
            extend: 'excelHtml5',
            title: 'Reporte_de_Inventario',
            filename: 'Reporte_Inventario_' + new Date().toISOString().split('T')[0],
            exportOptions: {
                columns: ':visible'
            }
        },
        {
            extend: 'pdfHtml5',
            title: 'Reporte de Inventario',
            orientation: 'landscape', // Horizontal para más espacio
            pageSize: 'A4',
            download: 'open',
            filename: 'Reporte_Inventario_' + new Date().toISOString().split('T')[0],
            exportOptions: {
                columns: ':visible'
            },
            customize: function (doc) {
                // === CONFIGURACIÓN GENERAL ===
                doc.defaultStyle = {
                    fontSize: 9,
                };

                // === HEADER EMPRESARIAL ===
                doc.content.splice(0, 1); // Eliminar título por defecto
                
                // Agregar header personalizado
                doc.content.unshift({
                    columns: [
                        {
                            // Logo o información de la empresa (lado izquierdo)
                            width: '50%',
                            stack: [
                                { 
                                    text: 'EMPRESA SIS - VENTAS', 
                                    style: 'companyName',
                                    margin: [0, 0, 0, 5]
                                },
                                { 
                                    text: 'Sistema de Gestión de Inventario', 
                                    style: 'companySubtitle',
                                    margin: [0, 0, 0, 2]
                                },
                                { 
                                    text: 'Tel: +51 99999999 | Email: comticom@gmail.com', 
                                    style: 'companyContact'
                                }
                            ]
                        },
                        {
                            // Información del reporte (lado derecho)
                            width: '50%',
                            stack: [
                                { 
                                    text: 'REPORTE DE INVENTARIO', 
                                    style: 'reportTitle',
                                    alignment: 'right',
                                    margin: [0, 0, 0, 10]
                                },
                                { 
                                    text: 'Fecha de generación: ' + new Date().toLocaleDateString('es-ES'), 
                                    style: 'reportDate',
                                    alignment: 'right',
                                    margin: [0, 0, 0, 2]
                                },
                                { 
                                    text: 'Hora: ' + new Date().toLocaleTimeString('es-ES'), 
                                    style: 'reportDate',
                                    alignment: 'right'
                                }
                            ]
                        }
                    ],
                    margin: [0, 0, 0, 20]
                });

                // === ESTILOS PERSONALIZADOS ===
                doc.styles = {
                    // Estilos del header empresarial
                    companyName: {
                        fontSize: 18,
                        bold: true,
                        color: '#1a365d'
                    },
                    companySubtitle: {
                        fontSize: 11,
                        color: '#4a5568',
                        italics: true
                    },
                    companyContact: {
                        fontSize: 8,
                        color: '#718096'
                    },
                    
                    // Estilos del título del reporte
                    reportTitle: {
                        fontSize: 16,
                        bold: true,
                        color: '#1a365d'
                    },
                    reportDate: {
                        fontSize: 9,
                        color: '#4a5568'
                    },

                    // Estilos de la tabla
                    tableHeader: {
                        fontSize: 10,
                        bold: true,
                        fillColor: '#2d3748',
                        color: 'white',
                        alignment: 'center',
                        margin: [5, 8, 5, 8]
                    },
                    tableBody: {
                        fontSize: 9,
                        margin: [5, 5, 5, 5]
                    },
                    
                    // Otros estilos
                    footer: {
                        fontSize: 8,
                        color: '#718096',
                        alignment: 'center'
                    }
                };

                // === CONFIGURACIÓN DE LA TABLA ===
                if (doc.content[1] && doc.content[1].table) {
                    var table = doc.content[1].table;
                    
                    // Configurar anchos de columnas específicos para inventario
                    table.widths = ['20%', '15%', '15%', '15%', '15%', '20%']; // Ajustado para las 6 columnas
                    
                    // Aplicar estilos a las celdas del encabezado
                    table.body[0].forEach(function(cell, index) {
                        cell.style = 'tableHeader';
                        cell.fillColor = '#2d3748';
                        cell.color = 'white';
                    });

                    // Aplicar estilos a las filas de datos (alternar colores)
                    for (var i = 1; i < table.body.length; i++) {
                        table.body[i].forEach(function(cell, colIndex) {
                            cell.style = 'tableBody';
                            // Alternar colores de fila
                            if (i % 2 === 0) {
                                cell.fillColor = '#f7fafc';
                            } else {
                                cell.fillColor = '#ffffff';
                            }
                            
                            // Alineación específica por columna de inventario
                            if (colIndex === 2) { // Código
                                cell.alignment = 'center';
                            } else if (colIndex === 5) { // Serie
                                cell.alignment = 'center';
                            } else {
                                cell.alignment = 'left';
                            }
                        });
                    }

                    // Bordes de la tabla
                    table.layout = {
                        hLineWidth: function (i, node) {
                            return (i === 0 || i === 1 || i === node.table.body.length) ? 1 : 0.5;
                        },
                        vLineWidth: function (i, node) {
                            return 0.5;
                        },
                        hLineColor: function (i, node) {
                            return (i === 0 || i === 1) ? '#2d3748' : '#e2e8f0';
                        },
                        vLineColor: function (i, node) {
                            return '#e2e8f0';
                        }
                    };
                }

                // === FOOTER ===
                doc.footer = function(currentPage, pageCount) {
                    return {
                        columns: [
                            {
                                text: 'Sistema de Gestión - Empresa S.A.',
                                style: 'footer',
                                alignment: 'left'
                            },
                            {
                                text: 'Página ' + currentPage + ' de ' + pageCount,
                                style: 'footer',
                                alignment: 'right'
                            }
                        ],
                        margin: [40, 10, 40, 0]
                    };
                };

                // === MÁRGENES DEL DOCUMENTO ===
                doc.pageMargins = [40, 20, 40, 40];
            }
        },
        {
            extend: 'print',
            title: 'Reporte de Inventario',
            customize: function (win) {
                // Estilos para impresión
                $(win.document.body)
                    .css('font-size', '10pt')
                    .prepend(
                        '<div style="text-align:center; margin-bottom: 20px;">' +
                        '<h2 style="margin:0; color:#1a365d;">EMPRESA S.A.</h2>' +
                        '<h3 style="margin:5px 0; color:#4a5568;">Reporte de Inventario</h3>' +
                        '<p style="margin:0; font-size:9pt; color:#718096;">Generado el: ' + new Date().toLocaleDateString('es-ES') + '</p>' +
                        '</div>'
                    );

                $(win.document.body).find('table')
                    .addClass('compact')
                    .css('font-size', '9pt');
            }
        }
    ],

    "language": {
        "sProcessing":     "Procesando...",
        "sLengthMenu":     "Mostrar _MENU_ registros",
        "sZeroRecords":    "No se encontraron resultados",
        "sEmptyTable":     "Ningún dato disponible en esta tabla",
        "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
        "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
        "sSearch":         "Buscar:",
        "sLoadingRecords": "Cargando...",
        "oPaginate": {
            "sFirst":    "Primero",
            "sLast":     "Último",
            "sNext":     "Siguiente",
            "sPrevious": "Anterior"
        },
        "oAria": {
            "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
            "sSortDescending": ": Activar para ordenar la columna de manera descendente"
        }
    }
});
</script>