<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <!-- Espacio para un título si lo requieres -->
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                <script src="https://cdn.jsdelivr.net/npm/@tensorflow/tfjs"></script>
                                <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
                                <script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns"></script>

                                <canvas id="salesChart" width="400" height="200"></canvas>
                                <?php
                                $base = Database::getInstance();
                                $conn = $base->getConnection();
                                $sql = "
                                SELECT p.id, p.articulo, p.cantidad, p.precio, p.total, p.accion, p.fecha, a.nombre, a.categoria, a.marca, a.serie, a.modelo, a.estado, a.color
                                FROM proceso p
                                JOIN articulo a ON p.articulo = a.id
                                WHERE p.accion = 2
                                ";

                                $result = $conn->query($sql);

                                $data = [];

                                if ($result->num_rows > 0) {
                                    while($row = $result->fetch_assoc()) {
                                        $date = new DateTime($row['fecha']);
                                        $month = $date->format('Y-m');
                                        $article = $row['articulo'];

                                        if (!isset($data[$month])) {
                                            $data[$month] = [];
                                        }
                                        if (!isset($data[$month][$article])) {
                                            $data[$month][$article] = 0;
                                        }

                                        $data[$month][$article]++;
                                    }
                                }
                                $conn->close();

                                echo "<script>console.log('Sales Data:', " . json_encode($data) . ");</script>";
                                echo "<script>var salesData = " . json_encode($data) . ";</script>";
                                ?>
                                <script>
                                    function prepareData(data) {
                                        const labels = Object.keys(data).sort();
                                        const articles = [...new Set(labels.flatMap(month => Object.keys(data[month])))];
                                        const dataset = articles.map(article => {
                                            return {
                                                label: `Producto ${article}`,
                                                data: labels.map(month => data[month][article] || 0),
                                                fill: false,
                                                borderColor: getRandomColor(),
                                                tension: 0.1
                                            };
                                        });

                                        return { labels, dataset };
                                    }

                                    function getRandomColor() {
                                        const letters = '0123456789ABCDEF';
                                        let color = '#';
                                        for (let i = 0; i < 6; i++) {
                                            color += letters[Math.floor(Math.random() * 16)];
                                        }
                                        return color;
                                    }

                                    console.log('Sales Data:', salesData);

                                    const { labels, dataset } = prepareData(salesData);

                                    console.log('Labels:', labels);
                                    console.log('Dataset:', dataset);

                                    const ctx = document.getElementById('salesChart').getContext('2d');
                                    const salesChart = new Chart(ctx, {
                                        type: 'line',
                                        data: {
                                            labels: labels,
                                            datasets: dataset
                                        },
                                        options: {
                                            scales: {
                                                x: {
                                                    type: 'time',
                                                    time: {
                                                        unit: 'month'
                                                    },
                                                    title: {
                                                        display: true,
                                                        text: 'Mes'
                                                    }
                                                },
                                                y: {
                                                    ticks: {
                                                        callback: function(value) {
                                                            return Math.round(value); // Mostrar valores enteros
                                                        }
                                                    },
                                                    title: {
                                                        display: true,
                                                        text: 'Ventas'
                                                    }
                                                }
                                            },
                                            plugins: {
                                                tooltip: {
                                                    callbacks: {
                                                        label: function(context) {
                                                            return `Producto: ${context.dataset.label.split(' ')[1]}, Ventas: ${Math.round(context.raw)}`;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    });

                                    async function generateFutureData() {
                                        const model = tf.sequential();
                                        model.add(tf.layers.dense({units: 128, inputShape: [1], activation: 'relu'}));
                                        model.add(tf.layers.dense({units: 128, activation: 'relu'}));
                                        model.add(tf.layers.dropout({rate: 0.2}));
                                        model.add(tf.layers.dense({units: 64, activation: 'relu'}));
                                        model.add(tf.layers.dense({units: dataset.length}));

                                        model.compile({optimizer: tf.train.adam(), loss: 'meanSquaredError'});

                                        const xs = tf.tensor2d(labels.map((_, i) => [i]), [labels.length, 1]);
                                        const ys = tf.tensor2d(labels.map((_, i) => dataset.map(d => d.data[i] || 0)), [labels.length, dataset.length]);

                                        await model.fit(xs, ys, {
                                            epochs: 2000,
                                            validationSplit: 0.2,
                                            callbacks: tf.callbacks.earlyStopping({monitor: 'val_loss', patience: 50})
                                        });

                                        const futureX = tf.tensor2d([...Array(6).keys()].map(i => [i + labels.length]), [6, 1]);
                                        const predictions = model.predict(futureX);

                                        predictions.array().then(preds => {
                                            const futureLabels = Array.from({length: 6}, (_, i) => {
                                                const date = new Date(labels[labels.length - 1]);
                                                date.setMonth(date.getMonth() + i + 1);
                                                return date.toISOString().substring(0, 7);
                                            });

                                            const futureDataset = dataset.map((d, i) => ({
                                                ...d,
                                                data: [...d.data, ...preds.map(p => Math.round(p[i]))] // Redondear predicciones a enteros
                                            }));

                                            salesChart.data.labels = [...labels, ...futureLabels];
                                            salesChart.data.datasets = futureDataset;
                                            salesChart.update();
                                        });
                                    }
                                    generateFutureData();
                                </script>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 