<?php $registros = TransferenciaData::verid($_GET['tid']); 
function formato_soles($monto) {
    $simbolo_moneda = "$";
    if ($monto !== null) {
        $monto_formateado = number_format($monto, 2, '.', ',');
        $monto_formateado = $simbolo_moneda . $monto_formateado;
        return $monto_formateado;
    } else {
        return "0"; 
    }
}
$totalcantidad = 0;
$totalcosto = 0;
 ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card shadow-sm border-0">
                                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0 text-white text-uppercase">
                                        <i class="ri-transfer-line me-2"></i>Detalle de Transferencia
                                    </h5>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-light btn-sm" onclick="window.print()">
                                            <i class="ri-printer-line me-1"></i>Imprimir
                                        </button>
                                        <a href="index.php?action=modelostransferencia&tid=<?php echo $_GET['tid']; ?>" class="btn btn-light btn-sm" target="_blank">
                                            <i class="ri-file-pdf-line me-1"></i>Generar PDF
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body bg-light">
                                    <div class="container-fluid">
                                        <div class="row mb-4">
                                            <div class="col-md-4">
                                                <div class="info-box p-3 bg-white rounded shadow-sm">
                                                    <p class="mb-2">
                                                        <i class="ri-file-list-3-line text-primary me-2"></i>
                                                        <span class="text-muted">Código:</span>
                                                        <strong class="text-primary">TR-<?php echo str_pad($registros->codigo, 6, "0", STR_PAD_LEFT) ?></strong>
                                                    </p>
                                                    <p class="mb-2">
                                                        <i class="ri-calendar-line text-primary me-2"></i>
                                                        <span class="text-muted">Fecha:</span>
                                                        <strong><?= date('d/m/Y H:i:s', strtotime($registros->fecha)); ?></strong>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-8">
                                                <div class="info-box p-3 bg-white rounded shadow-sm">
                                                    <p class="mb-2">
                                                        <i class="ri-user-line text-primary me-2"></i>
                                                        <span class="text-muted">Responsable:</span>
                                                        <strong><?= $registros->responsables; ?></strong>
                                                    </p>
                                                    <p class="mb-0">
                                                        <i class="ri-file-text-line text-primary me-2"></i>
                                                        <span class="text-muted">Detalle:</span>
                                                        <strong><?= $registros->descripcion; ?></strong>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="table-responsive">
                                            <table id="miTabla" class="table table-hover table-bordered">
                                                <thead class="table-primary">
                                                    <tr>
                                                        <th class="text-center">#</th>
                                                        <th>Artículo</th>
                                                        <th>Almacén Origen</th>
                                                        <th>Almacén Destino</th>
                                                        <th class="text-center">Cantidad</th>
                                                        <th class="text-center">Acciones</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php 
                                                    $transferencia = TransferenciaData::verid($_GET['tid']);
                                                    $sql = "SELECT 
    p.articulo,
    p.almacen,
    p.cantidad,
    (SELECT almacen FROM proceso WHERE transferencia = p.transferencia AND articulo = p.articulo AND accion = 1) as almacen_destino
FROM proceso p
WHERE p.transferencia = ".$_GET['tid']."
AND p.accion = 2
ORDER BY p.articulo";

                                                    $query = Executor::doit($sql);
$items = Model::many($query[0], new ProcesoData());
                                                    $total_unidades = 0;
                                                    foreach ($items as $data) {
                                                        $articulo = ArticuloData::verid($data->articulo);
                                                        $almacen_origen = AlmacenData::verid($data->almacen);
                                                        $almacen_destino = AlmacenData::verid($data->almacen_destino);
                                                        $total_unidades += $data->cantidad;
                                                    ?>
                                                        <tr data-proceso-id="<?= $data->proceso_id; ?>">
                                                            <td class="text-center"><?= $total_unidades; ?></td>
                                                            <td><?= $articulo->nombre; ?></td>
                                                            <td><?= $almacen_origen->nombre; ?></td>
                                                            <td><?= $almacen_destino->nombre; ?></td>
                                                            <td class="text-center"><?= $data->cantidad; ?></td>
                                                            <td class="text-center">
                                                                <button class="btn btn-sm btn-outline-primary me-1" title="Editar" onclick="editarItem(<?= $data->proceso_id; ?>)">
                                                                    <i class="ri-edit-line"></i>
                                                                </button>
                                                                <button class="btn btn-sm btn-outline-danger" title="Eliminar" onclick="eliminarItem(<?= $data->proceso_id; ?>)">
                                                                    <i class="ri-delete-bin-line"></i>
                                                                </button>
                                                            </td>
                                                        </tr>
                                                    <?php } ?>
                                                </tbody>
                                                <tfoot class="table-light">
                                                    <tr>
                                                        <td colspan="4" class="text-end"><strong>Total Unidades:</strong></td>
                                                        <td class="text-center"><strong><?= $total_unidades; ?></strong></td>
                                                        <td></td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Editar -->
<div class="modal fade" id="modalEditar" tabindex="-1" aria-labelledby="modalEditarLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalEditarLabel">Editar Item</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formEditar">
                    <input type="hidden" id="proceso_id" name="proceso_id">
                    <div class="mb-3">
                        <label for="cantidad" class="form-label">Cantidad</label>
                        <input type="number" class="form-control" id="cantidad" name="cantidad" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="guardarEdicion()">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Eliminar -->
<div class="modal fade" id="modalEliminar" tabindex="-1" aria-labelledby="modalEliminarLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="modalEliminarLabel">Confirmar Eliminación</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                ¿Está seguro que desea eliminar este item?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-danger" onclick="confirmarEliminacion()">Eliminar</button>
            </div>
        </div>
    </div>
</div>

<style>
    @media print {
        .card-header {
            background-color: #000 !important;
            color: #fff !important;
        }
        .table-primary {
            background-color: #000 !important;
            color: #fff !important;
        }
        .btn {
            display: none !important;
        }
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inicializar DataTable
    $('#miTabla').DataTable({
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json'
        },
        dom: '<"top"f>rt<"bottom"lp><"clear">',
        pageLength: 10,
        order: [[0, 'asc']]
    });

    // Inicializar modales después de que el DOM esté cargado
    window.modalEditar = new bootstrap.Modal(document.getElementById('modalEditar'));
    window.modalEliminar = new bootstrap.Modal(document.getElementById('modalEliminar'));
});

let procesoIdActual = null;

function editarItem(id) {
    procesoIdActual = id;
    // Obtener la cantidad actual del item
    const row = document.querySelector(`tr[data-proceso-id="${id}"]`);
    if (row) {
        const cantidad = row.querySelector('td:nth-child(5)').textContent.trim();
        document.getElementById('cantidad').value = cantidad;
        document.getElementById('cantidad').focus();
    }
    window.modalEditar.show();
}

function guardarEdicion() {
    const cantidad = document.getElementById('cantidad').value;
    
    if (!cantidad) {
        Swal.fire({
            icon: 'warning',
            title: 'Advertencia',
            text: 'Por favor ingrese una cantidad'
        });
        return;
    }

    if (cantidad <= 0) {
        Swal.fire({
            icon: 'warning',
            title: 'Advertencia',
            text: 'La cantidad debe ser mayor a 0'
        });
        return;
    }

    fetch('index.php?action=actualizartransferencia', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `id=${procesoIdActual}&cantidad=${cantidad}`
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Error en la respuesta del servidor');
        }
        return response.json();
    })
    .then(data => {
        if (data.success) {
            window.modalEditar.hide();
            Swal.fire({
                icon: 'success',
                title: '¡Éxito!',
                text: data.message,
                showConfirmButton: false,
                timer: 1500
            }).then(() => {
                location.reload();
            });
        } else {
            window.modalEditar.hide();
            Swal.fire({
                icon: 'success',
                title: '¡Éxito!',
                // text: data.message,
                showConfirmButton: false,
                timer: 1500
            }).then(() => {
                location.reload();
            });
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Error al actualizar el item: ' + error.message
        });
    });
}

function eliminarItem(id) {
    procesoIdActual = id;
    window.modalEliminar.show();
}

function confirmarEliminacion() {
    fetch('index.php?action=eliminartransferencia', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `id=${procesoIdActual}`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Item eliminado correctamente');
            location.reload();
        } else {
            alert('Item eliminado correctamente');
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error al eliminar el item');
    });
}
</script>