<?php
class ArticuloData {
    public static $tablename = "articulo";
        public $id;
        public $nombre;
        public $categoria;
        public $marca;
        public $serie;
        public $modelo;
        public $estado;
        public $color;
        public $descripcion;
        public $vencimiento;
        public $par;
        public $talla;
        public $imagen;
        public $codigo;
        public $codigo1;
        public $codigo2;
        public $rutaarchivoqr;
        public $qr;
        public $barcode;
        public $fecha;
        public $count;
        public $total;
        public $categorias;
        public $cantidad_disponible;
        public $producto_id;
        public $almacen_nombre;
        public $stock_actual;
        public $stock_minimo;
        public function registro(){
            $sql = "insert into ".self::$tablename." (nombre,categoria,marca,serie,modelo,color,estado,vencimiento,talla,par,imagen,codigo,descripcion,codigo1,codigo2,rutaarchivoqr,qr,barcode,fecha) ";
            $sql .= "value (\"$this->nombre\",\"$this->categoria\",\"$this->marca\",\"$this->serie\",\"$this->modelo\",\"$this->color\",\"$this->estado\",\"$this->vencimiento\",\"$this->talla\",\"$this->par\",\"$this->imagen\",\"$this->codigo\",\"$this->descripcion\",\"$this->codigo1\",\"$this->codigo2\",\"$this->rutaarchivoqr\",\"$this->qr\",\"$this->barcode\",NOW())";
            return Executor::doit($sql);
        }
        public function actualizar(){
            $sql = "update ".self::$tablename." set nombre=\"$this->nombre\", categoria=\"$this->categoria\", marca=\"$this->marca\", serie=\"$this->serie\", modelo=\"$this->modelo\", color=\"$this->color\", estado=\"$this->estado\", vencimiento=\"$this->vencimiento\", talla=\"$this->talla\", par=\"$this->par\", descripcion=\"$this->descripcion\", imagen=\"$this->imagen\", codigo=\"$this->codigo\", codigo1=\"$this->codigo1\", codigo2=\"$this->codigo2\", rutaarchivoqr=\"$this->rutaarchivoqr\" where id=$this->id";
            Executor::doit($sql);
        }
        public function qr(){
            $sql = "update ".self::$tablename." set rutaarchivoqr=\"$this->rutaarchivoqr\", qr=\"$this->qr\", barcode=\"$this->barcode\" where id=$this->id";
            Executor::doit($sql);
        }
        // public function qr() {
        //     $sql = "UPDATE " . self::$tablename . " 
        //             SET rutaarchivoqr = :rutaarchivoqr, 
        //                 qr = :qr, 
        //                 barcode = :barcode 
        //             WHERE id = :id";
        //     $params = [
        //         ':rutaarchivoqr' => $this->rutaarchivoqr,
        //         ':qr' => $this->qr,
        //         ':barcode' => $this->barcode,
        //         ':id' => $this->id
        //     ];
        //     return Executor::doit($sql, $params);
        // }
        public static function verid($id){
            $sql = "select * from ".self::$tablename." where id=$id";
            $query = Executor::doit($sql);
            return Model::one($query[0],new ArticuloData());
        }
        public function eliminar(){
            $sql = "delete from ".self::$tablename." where id=$this->id";
            Executor::doit($sql);
        }

        public static function vercontenido(){
            $sql = "select a.*, c.nombre as categorias from ".self::$tablename." a JOIN categoria c ON c.id=a.categoria";
            $query = Executor::doit($sql);
            return Model::many($query[0],new ArticuloData());
        }
        public static function getById($id) {
            $sql = "SELECT * FROM ".self::$tablename." WHERE id = $id"; 
            $query = Executor::doit($sql);
            return Model::one($query[0], new ArticuloData());
        }

        public static function buscador($codigo){
            $sql = " select * from ".self::$tablename." where codigo=\"$codigo\" ";
            $query = Executor::doit($sql);
            return Model::many($query[0],new ArticuloData());
        }

        public static function duplicidad($codigo){
        $sql = "select * from ".self::$tablename." where codigo=\"$codigo\"";
        $query = Executor::doit($sql);
        $array = array();
        $cnt = 0;
        while($r = $query[0]->fetch_array()){
            $array[$cnt] = new ArticuloData();
            $array[$cnt]->codigo = $r['codigo'];
            $cnt++;
            }
            return $array;
        }
        public static function evitarladuplicidad($codigo, $id){
            $sql = "select * from ".self::$tablename." where codigo=\"$codigo\" AND id!=\"$id\"";
            $query = Executor::doit($sql);
            $result = $query[0]->fetch_array();
            if($result){
                return true;
            }else{
                return false;
            }
        }
        public static function vercontenidoPaginado($start, $length, $search = ''){
            $sql = "SELECT a.*, c.nombre as categorias  FROM ".self::$tablename;
            $sql .= " a JOIN categoria c ON c.id=a.categoria  ";
            if ($search) {
                $sql .= " WHERE a.nombre LIKE '%$search%' OR a.precio1 LIKE '%$search%'";
            }
            $sql .= " LIMIT $start, $length";
            $query = Executor::doit($sql);
            return Model::many($query[0], new ArticuloData());
        }
        public static function totalRegistro(){
            $sql = "select COUNT(*) as total from ".self::$tablename;
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new ArticuloData());
            return $result->total;
        }
        public static function totalRegistrosFiltrados($search){
            $sql = "select COUNT(*) as total from ".self::$tablename;
            if ($search) {
                $sql .= " WHERE nombre LIKE '%$search%' OR precio1 LIKE '%$search%'";
            }
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new ArticuloData());
            return $result->total;
        }
        // **************+
        public static function vercontenidoPaginado1($start, $length, $search = '') {
            $sql = "SELECT a.*, ca.nombre as categorias, ";
            $sql .= "(COALESCE((SELECT SUM(p1.cantidad) FROM proceso p1 WHERE p1.articulo = a.id AND p1.accion = 1), 0) - ";
            $sql .= "COALESCE((SELECT SUM(p2.cantidad) FROM proceso p2 WHERE p2.articulo = a.id AND p2.accion = 2), 0)) as cantidad_disponible ";
            $sql .= "FROM articulo a ";
            $sql .= "LEFT JOIN categoria ca ON ca.id = a.categoria ";
            if (!empty($search)) {
                $sql .= "WHERE a.nombre LIKE '%$search%' ";
            }
            $sql .= "GROUP BY a.id "; // Corregido aquí: usar 'a.id' en lugar de 'p.id'
            $sql .= "LIMIT $start, $length";
            $query = Executor::doit($sql);
            return Model::many($query[0], new ArticuloData());
        }
        public static function totalRegistro1(){
            $sql = "select COUNT(*) as total from ".self::$tablename;
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new ArticuloData());
            return $result->total;
        }
        public static function totalRegistrosFiltrados1($search){
            $sql = "select COUNT(*) as total from ".self::$tablename;
            if ($search) {
                $sql .= " WHERE nombre LIKE '%$search%'";
            }
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new ArticuloData());
            return $result->total;
        }
        public static function reporte1($desde, $hasta){
            $desde = date('Y-m-d', strtotime($desde));
            $hasta = date('Y-m-d', strtotime($hasta));

            if($desde == $hasta){
                $sql = " select a.*, c.nombre as categorias from  ".self::$tablename." a JOIN categoria c ON c.id=a.categoria   
                        WHERE date(a.fecha) = '$desde' 
                        ORDER BY a.fecha DESC";
            } else {
                $sql = " select a.*, c.nombre as categorias from  ".self::$tablename."  a JOIN categoria c ON c.id=a.categoria  
                        WHERE date(a.fecha) >= '$desde' AND date(a.fecha) <= '$hasta' 
                        ORDER BY a.fecha DESC";
            }

            $query = Executor::doit($sql);
            return Model::many($query[0],new ArticuloData());
        }
        public static function getLowStockCount() {
            $sql = "SELECT COUNT(*) as total FROM (
                SELECT a.id, 
                (COALESCE((SELECT SUM(p1.cantidad) FROM proceso p1 WHERE p1.articulo = a.id AND p1.accion = 1), 0) - 
                COALESCE((SELECT SUM(p2.cantidad) FROM proceso p2 WHERE p2.articulo = a.id AND p2.accion = 2), 0)) as stock_actual
                FROM articulo a
                HAVING stock_actual <= 10
            ) as subquery";
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new ArticuloData());
            return $result->total;
        }
        public static function getLowStockProducts() {
            $sql = "SELECT a.*, 
                (COALESCE((SELECT SUM(p1.cantidad) FROM proceso p1 WHERE p1.articulo = a.id AND p1.accion = 1), 0) - 
                COALESCE((SELECT SUM(p2.cantidad) FROM proceso p2 WHERE p2.articulo = a.id AND p2.accion = 2), 0)) as stock_actual,
                (SELECT al.nombre FROM proceso p 
                 JOIN almacen al ON al.id = p.almacen 
                 WHERE p.articulo = a.id 
                 ORDER BY p.fecha DESC 
                 LIMIT 1) as almacen_nombre 
                FROM articulo a 
                HAVING stock_actual <= 10 
                ORDER BY stock_actual ASC";
            $query = Executor::doit($sql);
            return Model::many($query[0], new ArticuloData());
        }

        public static function vercontenidoPaginado1_stock($start, $length, $search = '', $fechaInicio = null, $fechaFin = null) {
            $sql = "SELECT a.*, ca.nombre as categorias, ";
            
            // Subconsulta para entradas con filtro de fecha
            $sql .= "(COALESCE((SELECT SUM(p1.cantidad) FROM proceso p1 WHERE p1.articulo = a.id AND p1.accion = 1";
            if ($fechaInicio) {
                $sql .= " AND DATE(p1.fecha_creada) >= '$fechaInicio'";
            }
            if ($fechaFin) {
                $sql .= " AND DATE(p1.fecha_creada) <= '$fechaFin'";
            }
            $sql .= "), 0) - ";
            
            // Subconsulta para salidas con filtro de fecha
            $sql .= "COALESCE((SELECT SUM(p2.cantidad) FROM proceso p2 WHERE p2.articulo = a.id AND p2.accion = 2";
            if ($fechaInicio) {
                $sql .= " AND DATE(p2.fecha_creada) >= '$fechaInicio'";
            }
            if ($fechaFin) {
                $sql .= " AND DATE(p2.fecha_creada) <= '$fechaFin'";
            }
            $sql .= "), 0)) as cantidad_disponible ";
            
            $sql .= "FROM articulo a ";
            $sql .= "LEFT JOIN categoria ca ON ca.id = a.categoria ";
            
            if (!empty($search)) {
                $sql .= "WHERE a.nombre LIKE '%$search%' ";
            }
            
            $sql .= "GROUP BY a.id ";
            $sql .= "LIMIT $start, $length";
            
            $query = Executor::doit($sql);
            return Model::many($query[0], new ArticuloData());
        }

        public static function totalRegistro1_stock($fechaInicio = null, $fechaFin = null) {
            $sql = "SELECT COUNT(DISTINCT a.id) as total FROM articulo a ";
            
            // Si hay filtros de fecha, necesitamos JOIN con proceso para contar solo artículos con movimientos
            if ($fechaInicio || $fechaFin) {
                $sql .= "LEFT JOIN proceso p ON p.articulo = a.id ";
                $sql .= "WHERE 1=1 ";
                
                if ($fechaInicio) {
                    $sql .= "AND DATE(p.fecha_creada) >= '$fechaInicio' ";
                }
                if ($fechaFin) {
                    $sql .= "AND DATE(p.fecha_creada) <= '$fechaFin' ";
                }
            }
            
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new ArticuloData());
            return $result->total;
        }
        
        public static function totalRegistrosFiltrados1_stock($search, $fechaInicio = null, $fechaFin = null) {
            $sql = "SELECT COUNT(DISTINCT a.id) as total FROM articulo a ";
            
            // Si hay filtros de fecha, necesitamos JOIN con proceso
            if ($fechaInicio || $fechaFin) {
                $sql .= "LEFT JOIN proceso p ON p.articulo = a.id ";
            }
            
            $sql .= "WHERE 1=1 ";
            
            if ($search) {
                $sql .= "AND a.nombre LIKE '%$search%' ";
            }
            
            if ($fechaInicio) {
                $sql .= "AND DATE(p.fecha_creada) >= '$fechaInicio' ";
            }
            if ($fechaFin) {
                $sql .= "AND DATE(p.fecha_creada) <= '$fechaFin' ";
            }
            
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new ArticuloData());
            return $result->total;
        }

    
    }
?>