<?php
function formato_soles($monto) {
    $simbolo_moneda = "S/ ";
    if ($monto !== null) {
        $monto_formateado = number_format($monto, 2, '.', ',');
        $monto_formateado = $simbolo_moneda . $monto_formateado;
        return $monto_formateado;
    } else {
        return "0"; 
    }
}
$totalf=0;
$totalcant=0;
ini_set('display_errors', 0);
error_reporting(0);
ob_start();
$ventas = VentaData::verid($_GET['tid']);

require_once('tcpdf/tcpdf.php'); 

$pdf = new TCPDF('P', 'mm', array(80, 297), true, 'UTF-8', false); 
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('SISTEMA DE INVENTARIO');
$pdf->SetTitle('Ticket de Venta');
$pdf->SetSubject('Ticket');
$pdf->SetKeywords('TCPDF, PDF, ticket, venta');

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->SetMargins(4, 4, 4);
$pdf->AddPage();

// Estilos CSS para el ticket
$style = '
<style>
    .header {
        text-align: center;
        margin-bottom: 5mm;
    }
    .title {
        font-size: 12pt;
        font-weight: bold;
        color: #333;
        margin-bottom: 2mm;
    }
    .subtitle {
        font-size: 8pt;
        color: #666;
        margin-bottom: 1mm;
    }
    .info {
        font-size: 7pt;
        color: #444;
        margin-bottom: 1mm;
    }
    .label {
        font-weight: bold;
        color: #333;
    }
    .table {
        width: 100%;
        border-collapse: collapse;
        margin: 2mm 0;
    }
    .table th {
        background-color: #f5f5f5;
        font-weight: bold;
        color: #333;
        padding: 1mm;
        font-size: 6pt;
        border-bottom: 0.5pt solid #ddd;
    }
    .table td {
        padding: 1mm;
        font-size: 6pt;
        color: #444;
        border-bottom: 0.5pt solid #eee;
    }
    .total-row {
        font-weight: bold;
        background-color: #f9f9f9;
    }
    .footer {
        text-align: center;
        margin-top: 3mm;
        font-size: 6pt;
        color: #666;
    }
    .divider {
        border-top: 0.5pt dashed #ccc;
        margin: 2mm 0;
    }
</style>';

$html = $style;

// Encabezado
$html .= '
<div class="header">
    <div class="title">SISTEMA DE VENTAS</div>
    <div class="subtitle">SISTEMA DE INVENTARIO</div>
    <div class="info">CARRETERA FEDERAL KM 12</div>
    <div class="info">CANDELARIA PORTEZUELO</div>
    <div class="info">24912224424</div>
</div>';

// Información de la venta
$html .= '
<div class="info">
    <span class="label">Cliente:</span> '.$ventas->clientes.'<br>
    <span class="label">Fecha:</span> '.date('d/m/Y H:i', strtotime($ventas->fecha)).'<br>
    <span class="label">Ticket Nº:</span> '.$ventas->id.'<br>
    <span class="label">Forma de Pago:</span> ';

switch ($ventas->tipoventa) {
    case 1:
        $html .= 'Efectivo';
        break;
    case 2:
        $html .= 'Crédito';
        break;
    case 3:
        $html .= 'Depósito';
        break;
}

$html .= '<br><span class="label">Estado:</span> '.($ventas->estado ? "Pagado" : "Pago Incompleto").'
</div>';

// Tabla de productos
$html .= '
<table class="table">
    <thead>
        <tr>
            <th width="40%">Producto</th>
            <th width="20%" align="right">Cant.</th>
            <th width="40%" align="right">Precio</th>
        </tr>
    </thead>
    <tbody>';

$datas = ProcesoData::vercontenidos1($ventas->id);
foreach ($datas as $data) {
    $totalf += $data->cantidad * $data->precio;
    $totalcant += $data->cantidad;
    $html .= '
    <tr>
        <td>'.$data->articulos.'</td>
        <td align="right">'.number_format($data->cantidad/$data->cantidad_unidad, 2).' '.$data->unidades.'</td>
        <td align="right">'.formato_soles($data->precio).'</td>
    </tr>';
}

$html .= '
    </tbody>
    <tfoot>';

// Totales
$html .= '
    <tr class="total-row">
        <td colspan="2" align="right">SUBTOTAL:</td>
        <td align="right">'.formato_soles($ventas->subtotal).'</td>
    </tr>
    <tr class="total-row">
        <td colspan="2" align="right">DESCUENTO:</td>
        <td align="right">'.formato_soles($ventas->descuento).'</td>
    </tr>
    <tr class="total-row">
        <td colspan="2" align="right">IGV:</td>
        <td align="right">'.formato_soles($ventas->igv).'</td>
    </tr>
    <tr class="total-row">
        <td colspan="2" align="right">TOTAL:</td>
        <td align="right">'.formato_soles($ventas->total).'</td>
    </tr>';

if ($ventas->tipoventa == 2) {
    $html .= '
    <tr class="total-row">
        <td colspan="2" align="right">SALDO PENDIENTE:</td>
        <td align="right">'.formato_soles($ventas->adelanto).'</td>
    </tr>
    <tr class="total-row">
        <td colspan="2" align="right">SU PAGO:</td>
        <td align="right">'.formato_soles($ventas->total).'</td>
    </tr>
    <tr class="total-row">
        <td colspan="2" align="right">NUEVO SALDO:</td>
        <td align="right">'.formato_soles($ventas->adelanto).'</td>
    </tr>';
}

$html .= '
    </tfoot>
</table>';

// Pie de página
$html .= '
<div class="footer">
    <div class="divider"></div>
    <div>Cajero: '.$ventas->usuarios.'</div>
    <div>¡GRACIAS POR SU PREFERENCIA!</div>
    <div>www.tareacompleto.com.pe</div>
</div>';

$pdf->SetFont('helvetica', '', 8);
$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output('ticket.pdf', 'I');
ob_end_flush();
?>