<?php
require_once 'core/controller/Model.php';
require_once 'core/app/model/ArticuloData.php';
require_once 'core/app/model/UnidadData.php';
require_once 'core/app/model/AlmacenData.php';
require_once 'core/app/model/PrecioData.php';

$codigo = $_GET['codigo'];

// Buscar el producto por código
$producto = ArticuloData::buscador($codigo);

if(count($producto) > 0) {
    $articulo = $producto[0];
    
    // Obtener la primera unidad disponible
    $unidades = UnidadData::vercontenido();
    $unidad = count($unidades) > 0 ? $unidades[0] : null;
    
    // Obtener almacenes y verificar stock
    $almacenes = AlmacenData::vercontenido();
    $almacen_seleccionado = null;
    
    foreach($almacenes as $alm) {
        // Aquí deberías implementar la lógica para verificar el stock en cada almacén
        // Por ahora, seleccionamos el primer almacén disponible
        $almacen_seleccionado = $alm;
        break;
    }
    
    // Obtener el precio de venta
    $precios = PrecioData::vercontenido();
    $precio_venta = 0;
    $cantidad = 0;
    foreach($precios as $precio) {
        if($precio->articulo == $articulo->id) {
            $precio_venta = $precio->precio;
            $cantidad = $precio->cantidad;
            break;
        }
    }
    
    $response = array(
        'success' => true,
        'articulo' => array(
            'id' => $articulo->id,
            'nombre' => $articulo->nombre,
            'unidad_id' => $unidad ? $unidad->id : '',
            'unidad_nombre' => $unidad ? $unidad->nombre : '',
            'almacen_id' => $almacen_seleccionado ? $almacen_seleccionado->id : '',
            'almacen_nombre' => $almacen_seleccionado ? $almacen_seleccionado->nombre : '',
            'precio_venta' => $precio_venta,
            'cantidad_unidad' => $cantidad
        )
    );
} else {
    $response = array(
        'success' => false,
        'message' => 'Producto no encontrado'
    );
}

header('Content-Type: application/json');
echo json_encode($response);
?>